---
title: 4. 인증정보 조회 및 활용하기
description: 인증정보를 획득하고 활용하는 방법을 안내합니다.
targetVersions:
  - v1
versionVariants:
  v2: /opi/ko/extra/identity-verification/readme-v2
---

휴대폰 본인인증 완료이후 획득한 `imp_uid`를 이용하여 고객 인증정보를 조회할 수 있습니다.

## **STEP 01.** 인증정보(imp\_uid) 서버단에서 획득하기

아래는 휴대폰 본인인증 앞단에서 넘어온 값을 서버단에서 수신받은 예제 입니다.

<div class="tabs-container">

<div class="tabs-content" data-title="Node.js(팝업방식)">

```ts title="server-side"
app.use(bodyParser.json());
// "/certifications"에 대한 POST 요청을 처리하는 controller
app.post("/certifications", async (request, response) => {
  // request의 body에서 imp_uid 추출
  const { imp_uid } = request.body;
});
```

</div>

<div class="tabs-content" data-title="Node.js(리디렉션 방식)">

```ts title="server-side"
app.use(bodyParser.json());
// "/certifications/redirect"에 대한 GET 요청을 처리하는 controller
app.get("/certifications/redirect", async (request, response) => {
  const { imp_uid } = request.query; // request의 query에서 imp_uid 추출
});
```

</div>

</div>

## **STEP 02.** 인증 정보 조회하기

포트원 서버에서 인증 정보를 조회하기 위해서 먼저 [**REST API access token**](https://developers.portone.io/api/rest-v1/auth?v=v1#post%20%2Fusers%2FgetToken)을 발급받습니다. 발급받은 액세스 토큰(`access_token`)과 인증번호(`imp_uid`)로 **본인인증 결과조회 REST API** 를 호출하여 인증 정보를 조회하는 예제입니다.

```ts title="server-side"
app.use(bodyParser.json());
// "/certifications"에 대한 POST 요청을 처리하는 controller
app.post("/certifications", async (request, response) => {
  const { imp_uid } = request.body; // request의 body에서 imp_uid 추출
  try {
    // 인증 토큰 발급 받기
    const getToken = await axios({
      url: "https://api.iamport.kr/users/getToken",
      // POST method
      method: "post",
      // "Content-Type": "application/json"
      headers: { "Content-Type": "application/json" },
      data: {
        imp_key: "imp_apikey", // REST API키
        imp_secret:
          "ekKoeW8RyKuT0zgaZsUtXXTLQ4AhPFW3ZGseDA6bkA5lamv9OqDMnxyeB9wqOsuO9W3Mx9YSJ4dTqJ3f", // REST API Secret
      },
    });
    const { access_token } = getToken.data.response; // 인증 토큰
    // imp_uid로 인증 정보 조회
    const getCertifications = await axios({
      // imp_uid 전달
      url: `https://api.iamport.kr/certifications/${imp_uid}`,
      // GET method
      method: "get",
      // 인증 토큰 Authorization header에 추가
      headers: { Authorization: access_token },
    });
    const certificationsInfo = getCertifications.data; // 조회한 인증 정보
    // ...
  } catch (e) {
    console.error(e);
  }
});
```

## **STEP 03.** 인증 정보 활용하기

조회한 인증 정보에서 다음의 고객 정보를 추출하는 서비스 코드 예제입니다.

- `name`: 이름
- `gender`: 성별
- `birthday`: 생년월일(YYYY-MM-DD)
- `unique_key`: CI 값과 동일. 온라인 주민번호와 같은 개인고유식별키
- `unique_in_site`: DI 값과 동일. 상점아이디(사이트)별로 할당되는 식별키

<div class="hint" data-style="info">

위의 정보 외에 휴대폰 번호(**`phone`**) 및 통신사(**`carrier`**) 또는 외국인(**`foreigner`**) 여부는 **개인정보 제공동의 약관을 사이트에 게재**한 후 **<cs@portone.io>로 신청**하여 취득할 수 있습니다. 해당 부분은 당사 계약 이후 다날PG사로 요청 후 승인이 완료되면 이용 가능한 점 참고해 주시기 바랍니다.

**메일 요청 신청 양식**

- 상호명 :
- 사업자번호 :
- 본인인증용 다날 상점ID(CPID) :
- 업종 :
- 필요사유 :
- 개인정보취급방침 url : 앱서비스로 URL형태로 전달이 어려우신 경우 '개인정보취급방침' 경로를 캡쳐하여 전달주시기 바랍니다.

**참고 - 포트원 이용 고객사의 개인정보처리방침 적용 예시**

- `(주)마플 : https://marpple.shop/kr/@/privacy`
- `(주)브레이브모바일 / 숨고 : https://soomgo.com/terms/privacy`
- `(주)마켓잇 : https://static.marketit.asia/static/privacy-terms.pdf`

</div>

```ts title="Node.js"
// "/certifications"에 대한 POST 요청을 처리하는 controller
app.post("/certifications", async (request, response) => {
  const { imp_uid } = request.body; // request의 body에서 imp_uid 추출
  try {
    // 인증 토큰 발급 받기
    /* ...중략... */
    // imp_uid로 인증 정보 조회
    /* ...중략... */
    const certificationsInfo = getCertifications.data; // 조회한 인증 정보
    // unique_key: 개인식별 고유 키, unique_in_site: 사이트 별 개인식별 고유 키
    const { unique_key, unique_in_site, name, gender, birthday } =
      certificationsInfo;
    // 연령 제한 로직
    if (new Date(birthday).getFullYear() <= 1999) {
      // 연령 만족
    } else {
      // 연령 미달
    }
    // 1인 1계정 허용 로직
    // DB에서 unique_key 조회 후 가입여부 검사
    Users.find({ certificationKey: unique_key }).then((user) => {
      if (!user) {
        // 신규 고객
      } else {
        // 이미 가입된 고객
      }
    });
  } catch (e) {
    console.error(e);
  }
});
```
