---
title: 일반결제 연동 유의사항
description: 나이스페이먼츠(신모듈) 일반결제 연동 유의사항을 소개합니다.
targetVersions:
  - v1
---

## 결제창 호출 실패 사유 알 수 없음

상점 아이디 설정 이슈, 파라미터 설정 오류 등으로 결제창 호출이 불가능한 경우
PG사로부터 정확한 사유를 전달받지 못하기 때문에 다음과 같이
“알 수 없는 이유로 결제가 중단되었습니다. 나이스페이로 문의(1661-0808)하세요.” 에러를 리턴합니다.
이 메시지를 받으신 경우 결제창 호출 시 사용한 파라미터 전문과 함께 포트원으로 문의해 주시길 바랍니다.

## 카드 결제

|기능                                 |사용 가능 여부                                                                                |
|-------------------------------------|----------------------------------------------------------------------------------------------|
|상점 부담 무이자 할부                |가능                                                                                          |
|다이렉트 호출                        |<span style="color:red"> **단독 사용 불가능** </span> (고정 할부 개월수가 함께 전달 되어야 함)|
|다이렉트 호출 + 고정 할부 개월수     |가능                                                                                          |
|다이렉트 호출 + 리스트 할부 개월수   |<span style="color:red"> **불가능** </span>                                                   |
|비 다이렉트 호출 + 고정 할부 개월수  |**PC만 가능**                                                                                 |
|비 다이렉트 호출 + 리스트 할부 개월수|**PC만 가능**                                                                                 |

### 토스뱅크 카드사 다이렉트 호출 미지원

나이스페이먼츠(신모듈)의 경우 토스뱅크 카드(card.direct.code = "092") 다이렉트 호출이 불가능합니다.

### 카드사 다이렉트 호출시 고정 할부 개월수 필수 입력

나이스페이먼츠(신모듈)는 **카드사 다이렉트 호출시
고정 할부 개월수를 <span style="color:red"> 필수 </span>로 입력**해야 합니다.
결제 금액이 할부 지원 금액 미만(일반적으로 50,000원 이상 결제 시 할부 기능을 지원하나
카드사에 따라 다를 수 있습니다.)인 경우 **할부 개월수를 0(일시불)으로 전달**해야 합니다.

<details>

<summary>BC 카드 다이렉트 호출 + 5개월 고정 할부</summary>

```ts
IMP.request_pay(
  {
    // ...중략
    channelKey: "{콘솔 내 연동 정보의 채널키}",
    pay_method: "card",
    card: {
      direct: {
        // 다이렉트 호출할 카드사 코드와 고정 할부 개월수를 모두 지정해야 함
        code: "361", // BC카드
        quota: 5, // 5개월 할부
      },
    },
  },
  // 콜백함수
);
```

</details>

<details>

<summary>삼성 카드 다이렉트 호출 + 일시불</summary>

```ts
IMP.request_pay(
  {
    // ...중략
    channelKey: "{콘솔 내 연동 정보의 채널키}",
    pay_method: "card",
    card: {
      direct: {
        // 다이렉트 호출 할 카드사 코드와 고정 할부 개월수를 모두 지정해야 함
        code: "365", // 삼성카드
        quota: 0, // 일시불
      },
    },
  },
  // 콜백함수
);
```

</details>

### 모바일 환경에서는 다이렉트 호출시에만 할부 옵션 설정 가능

나이스페이먼츠(신모듈)의 경우 일반 카드 결제 시(간편결제 제외) 할부 옵션(고정 할부 개월수)사용이 가능하나
**모바일 환경**에서는 **카드사 다이렉트 호출할 때만 할부 옵션 사용이 가능합니다.** 만약 모바일 환경에서 다이렉트 호출 코드 없이
할부 옵션을 전달하는 경우 무시됩니다.

<details>

<summary>모바일 환경에서 리스트 할부 개월수만 전달 → 전달한 파라미터가 무시되고 모든 할부 개월수 렌더링</summary>

```ts
IMP.request_pay(
  {
    // ...중략
    channelKey: "{콘솔 내 연동 정보의 채널키}",
    pay_method: "card",
    display: { card_quota: [2, 3, 4, 5, 6] }, // 2 ~ 6 개월 리스트 할부 개월수 적용 시도
  },
  // 콜백함수
);
```

(관련 이미지 첨부)

</details>

<details>

<summary>모바일 환경에서 3개월 고정 할부 개월수만 전달 → 전달한 파라미터가 무시되고 모든 할부 개월수 렌더링</summary>

```ts
// ...중략
IMP.request_pay(
  {
    channelKey: "{콘솔 내 연동 정보의 채널키}",
    pay_method: "card",
    display: { card_quota: [3] }, // 3개월 고정 할부 개월수 적용 시도
  },
  // 콜백함수
);
```

(관련 이미지 첨부)

</details>

## 가상계좌

### 가상계좌 입금 기한(`vbank_due`) 필수 입력

나이스페이먼츠(신모듈) 가상 계좌 발급 시, 입금 기한은 필수 입력해야 하며 아래 4가지 형식만 유효합니다.
입금 기한을 입력하지 않거나, 유효하지 않은 형식을 입력할 경우 가상계좌 발급 결제창이 호출되지 않고 "결제 창 호출에 실패하였습니다.
나이스페이 V2 가상계좌 발급시 유효한 입금 기한을 필수로 입력해야 합니다." 라는 에러 메세지가 리턴되오니 유의하시기 바랍니다.

- YYYY-MM-DD HH:mm:ss
- YYYYMMDDHHmmss
- YYYY-MM-DD
- YYYYMMDD

## 계좌이체

### 계좌이체 다이렉트 호출시 은행 코드 지정 불가능

나이스페이먼츠(신모듈) 계좌이체 다이렉트 호출은 은행 코드를 지정하지 않고 바로 뱅크페이 결제창이 띄워지는 구조입니다.

### 계좌이체 다이렉트 호출시 현금영수증 정보는 필수 입력

계좌이체 거래는 계좌에서 현금성 결제로 현금영수증 발급이 가능하므로 현금영수증 정보를 필수로 입력해야 합니다.
만약 입력하지 않을 경우 나이스페이먼츠(신모듈) 계좌이체 다이렉트 호출 시 **현금영수증 발급 유형은 필수 입력**입니다.
라는 에러 메시지가 뜨면서 결제창이 호출되지 않으니 유의하시기 바랍니다.

### 계좌이체 에스크로 결제시에는 다이렉트 호출 불가능

나이스페이먼츠 정책상 계좌이체 + 에스크로 결제시에는 다이렉트 호출이 불가능합니다.
아래와 같이 계좌이체 + 에스크로 + 다이렉트 호출을 위한 파라미터를 설정할 경우
"나이스페이 V2 계좌이체 에스크로 결제시 다이렉트 호출은 불가능합니다."라는 에러 메시지가 뜨면서
결제창이 호출되지 않으니 유의하시기 바랍니다.

### 계좌이체 에스크로 결제시 결제창에 올바른 이메일을 입력해야 함

존재하지 않는 이메일을 입력할 경우 **이메일 주소 오류**라는 에러 메시지와 함께 승인에 실패합니다.
또한 실제로 존재하는 이메일 도메인이더라도 나이스페이먼츠 정책상 유효하지 않다고 취급하는
이메일 주소(예: .finance로 끝나는 이메일 주소)를 입력한 경우 승인은 정상적으로 되지만
**이후 API로 에스크로 등록시 에스크로 구매 확정 이메일이 전송되지 않습니다.**

<details>

<summary>자세히 보기</summary>

```ts
IMP.request_pay(
  {
    // ...중략
    channelKey: "{콘솔 내 연동 정보의 채널키}",
    pay_method: "trans", // 계좌이체 결제
    escrow: true, // 에스크로 결제
  },
  // 콜백함수
);
```

(관련 이미지 첨부)

</details>

## 휴대폰 소액결제

### 실물/컨텐츠 여부(`digital`) 필수 입력

휴대폰 소액결제시 실물/컨텐츠 여부(digital) 파라미터는 필수 입력입니다.
입력하지 않는 경우 "나이스페이 V2 휴대폰 소액결제시 상품 유형 파라미터는 필수 입력입니다." 라는
에러 메시지가 뜨면서 결제창이 호출되지 않으니 유의하시기 바랍니다.

|digital|의미  |
|-------|------|
|true   |컨텐츠|
|false  |실물  |

또한 상점 아이디 설정과 실물/컨텐츠 여부가 불일치할 경우 "CPID 설정 오류"라는 메시지가 리턴되며
결제창 호출에 실패하니 유의하시기 바랍니다.

## 상품권 결제

### 컬쳐랜드(`cultureland`)만 지원

나이스페이먼츠(신모듈)은 상품권 결제시 컬쳐랜드만 지원하며 북앤라이프, 스마트문상 등은 지원하지 않습니다.

### MallUserID(`bypass.nice_v2.MallUserID`)는 필수 입력

나이스페이먼츠(신모듈) 상품권 결제시 고객사 구매자 ID를 의미하는 MalluserID는 필수 입력이며, bypass 파라미터로 전달할 수 있습니다.

### 승인 완료시 나이스페이먼츠로부터 승인번호(`apply_num`)가 전달되지 않음

나이스페이먼츠(신모듈)은 상품권 결제시에는 승인 번호를 전달하지 않아 승인번호 확인이 어렵습니다.
따라서 결제 내역 조회시 승인 번호는 null로 리턴됩니다.

<details>

<summary>결제내역 조회 API 호출 결과</summary>

```http
GET /payments/{imp_uid}

{
  // ...중략
  "status": "paid",
  "pay_method": "cultureland",
  "pg": "nice_v2",
  "apply_num": null
}
```

</details>

## 카카오페이

|기능                                 |사용 가능 여부                                                                                         |
|-------------------------------------|-------------------------------------------------------------------------------------------------------|
|상점 부담 무이자 할부                |<span style="color:red"> **불가능** </span>                                                            |
|다이렉트 호출                        |BC, 국민, 삼성, 신한, 현대, 롯데, 씨티, NH농협 그리고 하나 카드만 가능                                 |
|다이렉트 호출 + 고정 할부 개월수     |BC, 국민, 삼성, 신한, 현대, 롯데, 씨티, NH농협 그리고 하나 카드만 가능                                 |
|다이렉트 호출 + 리스트 할부 개월수   |<span style="color:red"> **불가능** </span>                                                            |
|비 다이렉트 호출 + 고정 할부 개월수  |<span style="color:red"> **단독 사용 불가능** </span> (다이렉트 호출 할 카드사 코드를 함께 전달해야 함)|
|비 다이렉트 호출 + 리스트 할부 개월수|<span style="color:red"> **불가능** </span>                                                            |

## 네이버페이

|기능                                 |사용 가능 여부                                                                                         |
|-------------------------------------|-------------------------------------------------------------------------------------------------------|
|상점 부담 무이자 할부                |<span style="color:red"> **불가능** </span>                                                            |
|다이렉트 호출                        |BC, 국민, 삼성, 신한, 현대, 롯데, 씨티, NH농협 그리고 하나 카드만 가능                                 |
|다이렉트 호출 + 고정 할부 개월수     |BC, 국민, 삼성, 신한, 현대, 롯데, 씨티, NH농협 그리고 하나 카드만 가능                                 |
|다이렉트 호출 + 리스트 할부 개월수   |가능(단, **일시불이 항상 포함** 됨)                                                                    |
|비 다이렉트 호출 + 고정 할부 개월수  |<span style="color:red"> **단독 사용 불가능** </span> (다이렉트 호출 할 카드사 코드를 함께 전달해야 함)|
|비 다이렉트 호출 + 리스트 할부 개월수|가능(단, **일시불이 항상 포함** 됨)                                                                    |

### 결제 수단 지정 시 카드 또는 포인트 지정 필요

나이스페이먼츠(신모듈)를 통한 네이버페이 결제 시 카드 또는 포인트 결제를 지정하여 호출해야합니다.
결제 수단(`pay_method`) 파라미터에 `naverpay` 입력은 불가능하며 `naverpay_card`(카드)
또는 `naverpay_point`(포인트/머니) 둘 중 하나로 입력해야 정상적으로 결제창이 호출되오니 유의하시기 바랍니다.

### 네이버페이 머니와 포인트 복합 결제시, 포인트가 먼저 사용 됨

네이버페이 포인트 결제시 네이버페이 머니, 포인트 또는 복합(머니와 포인트 함께 사용) 방식으로 결제가 가능하며,
만약 복합 방식으로 결제할 경우 포인트 금액이 먼저 차감됩니다.

### 네이버페이 포인트 결제시 현금영수증 정보 필수 입력

네이버페이 포인트 결제 시 현금영수증 발급이 가능하며 **현금영수증 정보를 필수로 입력**해야 합니다.
만약 입력하지 않을 경우 "나이스페이 V2 네이버페이 포인트 결제시 현금영수증 발급 유형은 필수 입력입니다."라는
에러 메시지가 뜨면서 결제창이 호출되지 않으니 유의하시기 바랍니다.
단, **네이버페이 머니로 결제할 경우에만 현금영수증이 발급**됩니다.
결제 금액 모두 네이버페이 포인트로 결제하는 경우에는 결제창 호출시 현금영수증 정보를 전달하더라도 발급되지 않습니다.

## 페이코

|기능                                 |사용 가능 여부                             |
|-------------------------------------|-------------------------------------------|
|상점 부담 무이자 할부                |가능                                       |
|다이렉트 호출                        |가능                                       |
|다이렉트 호출 + 고정 할부 개월수     |가능                                       |
|다이렉트 호출 + 리스트 할부 개월수   |가능                                       |
|비 다이렉트 호출 + 고정 할부 개월수  |<span style="color:red"> **불가능** </span>|
|비 다이렉트 호출 + 리스트 할부 개월수|가능                                       |

## 삼성페이/11Pay (구.SKPay)/SSGPAY

|기능                                 |사용 가능 여부                             |
|-------------------------------------|-------------------------------------------|
|상점 부담 무이자 할부                |가능                                       |
|다이렉트 호출                        |<span style="color:red"> **불가능** </span>|
|다이렉트 호출 + 고정 할부 개월수     |<span style="color:red"> **불가능** </span>|
|다이렉트 호출 + 리스트 할부 개월수   |<span style="color:red"> **불가능** </span>|
|비 다이렉트 호출 + 고정 할부 개월수  |<span style="color:red"> **불가능** </span>|
|비 다이렉트 호출 + 리스트 할부 개월수|<span style="color:red"> **불가능** </span>|

## 애플페이/LPAY

|기능                                 |사용 가능 여부                             |
|-------------------------------------|-------------------------------------------|
|상점 부담 무이자 할부                |<span style="color:red"> **불가능** </span>|
|다이렉트 호출                        |<span style="color:red"> **불가능** </span>|
|다이렉트 호출 + 고정 할부 개월수     |<span style="color:red"> **불가능** </span>|
|다이렉트 호출 + 리스트 할부 개월수   |<span style="color:red"> **불가능** </span>|
|비 다이렉트 호출 + 고정 할부 개월수  |<span style="color:red"> **불가능** </span>|
|비 다이렉트 호출 + 리스트 할부 개월수|<span style="color:red"> **불가능** </span>|

## SSG 은행계좌 결제

### SSGPAY 은행 계좌 결제 시 주문 번호에 특수 문자를 사용 불가능

SSGPAY 정책상 은행 계좌 결제시에는 **주문 번호(`merchant_uid`)에 특수 문자가 허용되지 않습니다.**
주문 번호에 특수문자 입력 시 "나이스페이 V2 SSGPAY 은행 계좌 결제시 주문 번호에 특수문자는 허용되지 않습니다."와 같은
에러 메시지가 리턴되면서 결제창이 호출되지 않으니 참고 부탁드립니다.

### SSGPAY 은행 계좌 결제시 현금영수증 정보는 필수 입력

SSGPAY 은행 계좌 거래는 현금성 결제로 현금영수증 발급이 가능하므로 **현금영수증 정보는 필수 입력**입니다.
만약 입력하지 않을 경우 "나이스페이 V2 SSGPAY 은행 계좌 결제시 현금영수증 발급 유형은 필수 입력입니다."라는
에러 메시지가 뜨면서 결제창이 호출되지 않으니 유의하시기 바랍니다.

<details>

<summary>파라미터 예시</summary>

```ts
IMP.request_pay({
  // ...중략
  channelKey: "{콘솔 내 연동 정보의 채널키}",
  pay_method: "ssgpay_bank",
  bypass: {
    cashReceiptType: "corporate", // 현금영수증 발급 유형(corporate: 지출증빙, personal: 소득공제)
    customerIdentifier: "1178178260", // 현금영수증 발행 식별 정보(사업자 등록번호 또는 휴대폰 번호)
  },
});
```

</details>

### SSGPAY 은행 계좌 결제시 현금영수증 발급 정보를 확인할 수 없음

SSGPAY 은행 계좌 결제 시 현금영수증 발급 정보를 입력하여 정상적으로 발급되더라도
승인 완료(status: paid)시 나이스페이먼츠에서 현금영수증 발급 정보를 전달하지 않아
포트원 API로 결제/현금영수증 발급 내역 조회 또는 포트원 콘솔에서 현금영수증 내역을 확인할 수 없습니다.
단, 나이스페이먼츠 어드민에서는 확인이 가능합니다.

<details>

<summary>결제내역 조회 API 호출 결과</summary>

```http
GET /payments/{imp_uid}

{
  // ...중략
  "pay_method": "trans",
  "emb_pg_provider": "ssgpay",
  "pg": "nice_v2",
  "status": "paid",
  "cash_receipt_issued": false // 실제로는 현금영수증이 발급됐으나 포트원에 정보가 없으므로 false로 내려감
}
```

</details>

<details>

<summary>현금영수증 발급 내역 조회 API 호출 결과</summary>

```http
GET /receipts/{imp_uid}

{
  "code": -1,
  "message": "해당 아임포트 고유 번호({아임포트 번호})로 현금영수증을 발급 한 내역이 존재하지 않습니다.",
  "data": null
}
```

</details>

<details>

<summary>V1 콘솔 현금영수증 발급 내역</summary>

(관련 이미지 첨부)

</details>

## 현금영수증

### 현금영수증 발급 유형 지원 여부

현금영수증 발급 유형(`cashReceiptType`)이 소득 공제(`personal`)인 경우,
현금영수증 발급 유형(`customerIdentifier`)은 휴대폰 번호만 가능하며 주민등록번호 입력시 "현금영수증 식별 번호가 올바르지 않습니다."라는
에러 메시지가 리턴되며 결제창이 호출되지 않으니 유의하시기 바랍니다.

**계좌이체 다이렉트 호출, 네이버페이 포인트 결제, SSGPAY 은행 계좌 결제시 현금영수증 정보는 필수 입력**입니다.

<details>

<summary>파라미터 예시</summary>

```ts
IMP.request_pay(
  {
    // ...중략
    channelKey: "{콘솔 내 연동 정보의 채널키}",
    pay_method: "naverpay_point", // 네이버페이 포인트 결제
    bypass: {
      cashReceiptType: "personal", // 소득공제
      customerIdentifier: "01012345678", // 핸드폰 번호 입력(주민등록번호 불가능)
    },
  },
  // 콜백함수
);
```

</details>

### 가상계좌, 계좌이체 결제 시 현금영수증 파라미터 사용이 불가능한 경우

결제창을 통한 가상계좌 발급 또는 계좌이체 비 다이렉트 호출 시에는 현금영수증 정보를
파라미터로 전달할 수 없기(전달해도 결제창에 자동 입력되지 않음)때문에 구매자가 결제창에 직접 현금영수증 정보를 입력해야 합니다.
