---
title: 나이스페이먼츠
description: 나이스페이먼츠 결제 연동 방법을 안내합니다.
targetVersions:
  - v2
versionVariants:
  v1: /opi/ko/integration/pg/v1/nice-v2/readme
---

## 채널 설정하기

- [결제대행사 채널 설정하기](https://developers.portone.io/opi/ko/integration/ready/readme#3-결제대행사-채널-설정하기) 페이지의 내용을 참고하여 채널 설정을 진행합니다.
  V2 결제 모듈을 사용하시려면 나이스페이먼츠(신모듈)로 연동하셔야 합니다.

## 가능한 결제수단

- **일반 결제**
  - `payMethod`파라미터를 결제수단에 따라 아래와 같이 설정해야 합니다.
    - 신용카드 : `CARD`
    - 실시간 계좌이체 : `TRANSFER`
    - 가상계좌 : `VIRTUAL_ACCOUNT`
    - 휴대폰 소액결제 : `MOBILE`
    - 상품권결제: `GIFT_CERTIFICATE`
    - 간편 결제 : `EASY_PAY`

- **결제창 빌링키 발급**
  - 결제창 빌링키 발급은 간편결제(네이버페이 / 카카오페이)만 지원하므로 `billingKeyMethod` 파라미터를 `EASY_PAY`로 설정해야 합니다.

- **API 수기(키인) 결제**
  - `method`파라미터를 `card`로 설정해야 합니다.

- **API 빌링키 발급**
  - `method`파라미터를 `card`로 설정해야 합니다.

## SDK 결제 요청하기

결제 요청 시에는 `requestPayment` 함수를 호출해야 합니다.
`channelKey`파라미터에 결제 채널 연동 시 생성된 채널 키값을 지정하여 나이스페이먼츠 채널 사용을 명시해주세요.

나이스페이먼츠 기준으로 작성한 예시 코드는 아래와 같습니다.

<div class="tabs-container">

<div class="tabs-content" data-title="SDK 결제 요청">

```ts
import * as PortOne from "@portone/browser-sdk/v2";
function requestPayment() {
  PortOne.requestPayment({
    storeId: "store-4ff4af41-85e3-4559-8eb8-0d08a2c6ceec", // 고객사 storeId로 변경해주세요.
    paymentId: `payment-${crypto.randomUUID()}`,
    orderName: "나이키 와플 트레이너 2 SD",
    totalAmount: 1000,
    currency: "CURRENCY_KRW",
    channelKey: "channel-key-9987cb87-6458-4888-b94e-68d9a2da896d", // 콘솔 결제 연동 화면에서 채널 연동 시 생성된 채널 키를 입력해주세요.
    payMethod: "CARD",
  });
}
```

</div>

</div>

### 주요 파라미터

- storeId: string

  포트원 계정에 생성된 상점을 식별하는 고유한 값으로 관리자 콘솔에서 확인할 수 있습니다.

- paymentId: string

  고객사에서 채번하는 주문 고유 번호로 매번 고유하게 채번되어야 합니다.

- orderName: string

  주문명으로 고객사에서 **40Byte** 이내로 자유롭게 입력합니다.

  **특수문자 유의사항**

  - 사용 가능 : **\_**
  - 사용 불가 : **% & | $ - + = \[ ]**
  - 사용 가능하나 권장하지 않음 : **( )**

- channelKey: string

  콘솔 결제 연동 화면에서 채널 연동 시 생성된 채널 키로 호출하고자 하는 채널을 지정합니다.

- totalAmount: number

  결제 금액으로 결제를 원하는 통화(currency)별 scale factor(소수점 몇번째 자리까지 유효한지)를 고려한 number 형식만 허용됩니다.

- currency: string

  결제통화로 원화 결제 시 `KRW`로 입력해야 합니다. 나이스페이먼츠의 경우 `KRW`와 `USD`를 지원합니다.

- payMethod: string

  결제수단으로 결제하고자 하는 결제수단의 값을 입력해야 합니다.

- taxFreeAmount?: number

  면세금액으로 나이스페이먼츠와 상점아이디 계약시 지정금액 혹은 복합과세 방식으로 계약한 경우 면세 처리를 위해 면세금액을 반드시 입력해야 합니다.

  면세금액 미 입력 시 면세금액은 0원으로 자동 처리되며, 결제 요청 금액은 모두 과세 처리 되오니 이 점 유의하시기 바랍니다.

### 유의할 파라미터

- `virtualAccount.accountExpiry`

  가상계좌 발급 시 입금 기한은 필수로 입력해야 합니다.

- `card.installment.monthOption.fixedMonth`

  나이스페이먼츠는 **카드사 다이렉트 호출시 고정 할부 개월수를 필수로 입력**해야 합니다. 결제
  금액이 할부 지원 금액 미만(대부분 50,000원이상 할부지원이나 카드사에 따라 상이함)인 경우 **할부
  개월수를 0(일시불)으로 전달**해야 합니다.

- `productType`

  휴대폰 소액 결제 시 실물/컨텐츠 여부(`productType`) 파라미터는 필수 입력입니다. 입력하지 않는
  경우 "나이스페이 V2 휴대폰 소액결제시 상품 유형 파라미터는 필수 입력입니다." 라는 에러 메시지가
  리턴되면서 결제창 호출에 실패하오니 유의하시기 바랍니다. 또한 상점아이디 설정과 실물/컨텐츠
  여부가 불일치할 경우 "CPID미설정 오류입나다."라는 메시지가 리턴되며 결제창 호출에 실패하니
  유의하시기 바랍니다.

- `giftCertificate.certificateType`

  나이스페이먼츠는 컬쳐랜드만 지원하므로 상품권 결제시 항상 `CULTURELAND`로 지정해주어야 합니다.

- `bypass.nice_v2.MallUserID`

  나이스페이먼츠 상품권 결제시 고객사 구매자 ID를 의미하는 MalluserID는 필수로 입력해주어야 합니다.

- `easyPay.availablePayMethods`

  나이스페이먼츠를 통한 간편결제 결제 요청 시 다른 간편결제 수단과 다르게 네이버페이, SSG페이, 토스페이의
  경우 어떤 방식으로 결제하느냐에 따라 availablePayMethods을 입력해야 합니다.

  - 네이버페이의 경우 카드 결제인 경우 `CARD`, 포인트 혹은 머니 결제인 경우 `CHARGE` 로 입력해야
    합니다.

  - SSG페이의 경우 계좌 결제인 경우 `TRANSFER`로 입력해야 하며, SSG페이는 계좌 결제 시에만
    다이렉트 호출이 가능합니다. 카드 혹은 머니 결제를 이용하시는 경우 `availablePayMethods`를
    제외한채 호출하시길 바랍니다.

  - 토스페이의 경우 카드 결제인 경우 `CARD`, 머니 결제인 경우 `CHARGE`로 입력해야 합니다.

## 결제창 빌링키 발급

빌링키 발급 요청 시에는 `requestIssueBillingKey` 함수를 호출해야 합니다.
`channelKey` 파라미터에 결제 채널 연동 후 생성된 채널 키값을 지정하여 나이스페이먼츠 채널 사용을 명시해주세요.

나이스페이먼츠 기준으로 작성한 예시 코드는 아래와 같습니다.

<div class="tabs-container">

<div class="tabs-content" data-title="SDK 빌링키 발급 요청">

```javascript
import * as PortOne from "@portone/browser-sdk/v2";
function requestIssueBillingKey() {
  PortOne.requestIssueBillingKey({
    storeId: "store-4ff4af41-85e3-4559-8eb8-0d08a2c6ceec", // 고객사 storeId로 변경해주세요.
    channelKey: "channel-key-3b37819a-1c72-4deb-a245-8c810af5403d", // 콘솔 결제 연동 화면에서 채널 연동 시 생성된 채널 키를 입력해주세요.
    billingKeyMethod: "EASY_PAY", // 간편결제만 지원합니다.
    issueId: "testIssueId",
    issueName: "testIssueName",
    customer: {
      fullName: "포트원",
      phoneNumber: "010-0000-1234",
      email: "test@portone.io",
    },
    easyPay: {
      easyPayProvider: "KAKAOPAY",
    },
  });
}
```

</div>

</div>

### 주요 파라미터

- storeId: string

  **스토어 아이디**

  포트원 계정에 생성된 상점을 식별하는 고유한 값으로 관리자 콘솔에서 확인할 수 있습니다.

- channelKey: string

  **채널 키**

  포트원 콘솔 내 \[연동 관리] > \[연동 정보] > \[채널 관리] 화면에서 채널 추가 시 생성되는 값입니다. 결제 호출 시 채널을 지정할 때 사용됩니다.

- billingKeyMethod: string

  **빌링키 발급수단**

  나이스페이먼츠는 결제창 방식으로 빌링키 발급 시 간편결제(네이버페이 / 카카오페이)만을 지원하므로 `EASY_PAY`로 설정해야 합니다.

- issueId: string

  **빌링키 발급 건 고유 ID**

  - 고객사에서 채번하여 사용해야 합니다.
  - 나이스페이먼츠의 경우 필수 입력해야 합니다.
  - 영문 대소문자와 숫자만 사용하여 40자 이내로 입력합니다.

- issueName: string

  **빌링키 발급 시 결제창에 표시되는 제목**

  - 나이스페이먼츠의 경우 필수 입력해야 합니다.

- customer?: object

  **고객 정보**

  - fullName?: string

    **구매자 전체 이름**

  - firstName?: string

    **구매자 이름**

  - lastName?: string

    **구매자 성**

  - phoneNumber?: string

    **구매자 연락처**

  - email?: string

    **구매자 이메일**

- easyPay: object

  - easyPayProvider: string

    **간편 결제 수단**

    - 카카오페이: `KAKAOPAY`
    - 네이버페이: `NAVERPAY`

  - availablePayMethods?: string\[]

    **노출을 허용할 결제 수단의 종류**

    네이버페이의 경우 카드와 포인트 중 하나를 선택해야 합니다.

    - 네이버페이 카드: `CARD`
    - 네이버페이 포인트: `CHARGE`

## API 수기(키인)결제 요청하기

수기(키인)로 결제하기 위해서는 `POST /payments/${PAYMENT_ID_HERE}/instant`를 이용하여 결제 요청을 해야합니다.

<div class="tabs-container">

<div class="tabs-content" data-title="API 수기(키인) 결제 요청">

```ts
// ... 수기(키인) 결제
const issueResponse = await axios({
  url: `https://api.portone.io/payments/${PAYMENT_ID_HERE}/instant`,
  method: "post",
  headers: { Authorization: `PortOne ${PORTONE_API_SECRET}` },
  data: {
    channelKey: "channel-key-9987cb87-****-****-****-********896d", // 콘솔 결제 연동 화면에서 채널 연동 시 생성된 채널 키를 입력해주세요.
    orderName: "나이키 와플 트레이너 2 SD",
    amount: {
      total: 10000,
      taxFree: 500,
    },
    currency: "KRW",
    customer: {
      name: {
        full: "홍길동",
      },
      email: "test@test.com",
      phoneNumber: "01012345678",
    },
    method: {
      card: {
        credential: {
          number: "1111111111111111",
          expiryMonth: "01",
          expiryYear: "20",
          birthOrBusinessRegistrationNumber: "900101",
          passwordTwoDigits: "00",
        },
        installmentMonth: 3, // 카드 할부 개월수
        useFreeInterestFromMerchant: true, // 고객사 분담 무이자 설정
        useCardPoint: true, // 카드 포인트 사용 설정
      },
    },
  },
});
```

</div>

</div>

### 주요 파라미터

- paymentId: string

  고객사에서 채번하는 주문 고유 번호로 매번 고유하게 채번되어야 하며, URL path에 포함돼야 합니다.

- channelKey: string

  콘솔 결제 연동 화면에서 채널 연동 시 생성된 채널 키로 호출하고자 하는 채널을 지정합니다.

- orderName: string

  주문명으로 고객사에서 자유롭게 입력합니다.

- amount: object

  결제 금액에 대한 정보를 담고있는 객체입니다.

  - total: number

    결제 금액으로 결제를 원하는 통화(currency)별 scale factor(소수점 몇번째 자리까지 유효한지)를 고려한 number 형식만 허용됩니다.

  - taxFree?: number

    면세 금액으로 나이스페이먼츠과 상점아이디 계약시 지정금액 혹은 복합과세 방식으로 계약한 경우 면세 처리를 위해 면세금액을 반드시 입력해야 합니다.
    면세금액 미 입력 시 면세금액은 0원으로 자동 처리되며, 결제 요청 금액은 모두 과세 처리 되오니 이 점 유의하시기 바랍니다.

  - currency: string

    결제통화로 원화 결제를 원할 시 `KRW`로 입력해야 합니다.

- method: object

  결제 수단에 대한 정보를 담고있는 객체입니다.

  - card: object

    - credential: object

      - number: string

        카드번호로 10자리 이상 20자리 이하의 숫자만 입력해야 합니다.

      - expiryMonth: string

        카드 유효기간의 월로 2자리 숫자만 입력해야 합니다.

      - expiryYear: string

        카드 유효기간의 년도로 2자리 숫자만 입력해야 합니다.

      - birthOrBusinessRegistrationNumber: string

        카드 소지자의 생년월일 혹은 사업자 등록번호로 6자리 숫자만 입력해야 합니다.

      - passwordTwoDigits: string

        카드 비밀번호 앞 2자리로 2자리 숫자만 입력해야 합니다.

    - installmentMonth?: number

      카드 할부 개월수로 0(일시불) 혹은 2\~12개월까지의 숫자만 입력해야 합니다.

    - useFreeInterestFromMerchant?: boolean

      고객사 부담 무이자 설정으로 `true` 혹은 `false`만 입력

    - useCardPoint?: boolean

      카드 포인트 사용 설정으로 `true` 혹은 `false`만 입력

### 유의할 파라미터

- `method.card.InstallmentMonth`

  카드 할부 개월수로 0(일시불) 혹은 2\~12개월까지의 숫자만 입력해야 합니다. 입력하지 않은 경우 일시불로 처리됩니다.

- `method.useFreeInterestFromMerchant`

  고객사 부담 무이자 설정으로 `true` 혹은 `false`만 입력.

- `method.card.useCardPoint`

  카드 할부 개월수로 0(일시불) 혹은 2\~12개월까지의 숫자만 입력해야 합니다. 입력하지 않은 경우 일시불로 처리됩니다.

## API 빌링키 발급 및 예약/반복 결제 요청하기

빌링키를 발급하기 위해서는 `POST /billing-keys`를 이용하여 빌링키 발급 요청을 해야합니다. 이후
발급된 빌링키로 예약/반복 결제를 하기위해 `POST /payments/${PAYMENT_ID_HERE}/schedule` 를 이용하여
결제를 예약합니다.

<div class="tabs-container">

<div class="tabs-content" data-title="API 빌링키 발급 요청">

```ts
const issueResponse = await axios({
  url: "https://api.portone.io/billing-keys",
  method: "post",
  headers: { Authorization: `PortOne ${PORTONE_API_SECRET}` },
  data: {
    channelKey: "channel-key-9987cb87-****-****-****-********896d", // 콘솔 결제 연동 화면에서 채널 연동 시 생성된 채널 키를 입력해주세요.
    customer: {
      id: "customer-1234", // 고객사에서 관리하는 고객 고유번호
    },
    method: {
      card: {
        credential: {
          number: "1111111111111111",
          expiryMonth: "01",
          expiryYear: "20",
          birthOrBusinessRegistrationNumber: "900101",
          passwordTwoDigits: "00",
        },
      },
    },
  },
});
```

</div>

<div class="tabs-content" data-title="API 예약/반복 결제">

```ts
const response = await axios({
  url: `https://api.portone.io/payments/${PAYMENT_ID_HERE}/schedule`,
  method: "post",
  headers: { Authorization: `PortOne ${PORTONE_API_SECRET}` },
  data: {
    payment: {
      billingKey: "billing-key-1", // 빌링키 발급 API를 통해 발급받은 빌링키
      orderName: "월간 이용권 정기결제",
      customer: {
        id: "customer-1234", // 고객사에서 관리하는 고객 고유번호
      },
      amount: {
        total: 10000,
        taxFree: 500,
      },
      currency: "KRW",
      useFreeInterestFromMerchant: true, // 고객사 분담 무이자 설정
      InstallmentMonth: 3, // 카드 할부 개월수
      useCardPoint: true, // 카드 포인트 사용 설정
    },
    timeToPay: "2023-01-01 00:00:00", // 결제를 시도할 시각
  },
});
```

</div>

</div>

### 빌링키 발급 주요 파라미터

- channelKey: string

  콘솔 결제 연동 화면에서 채널 연동 시 생성된 채널 키로 호출하고자 하는 채널을 지정합니다.

- method: object

  결제 수단에 대한 정보를 담고있는 객체입니다.

  - card: object

    - credential: object

      - number: string

        카드번호로 10자리 이상 20자리 이하의 숫자만 입력해야 합니다.

      - expiryMonth: string

        카드 유효기간의 월로 2자리 숫자만 입력해야 합니다.

      - expiryYear: string

        카드 유효기간의 년도로 2자리 숫자만 입력해야 합니다.

      - birthOrBusinessRegistrationNumber: string

        카드 소지자의 생년월일 혹은 사업자 등록번호로 6자리 숫자만 입력해야 합니다.

      - passwordTwoDigits: string

        카드 비밀번호 앞 2자리로 2자리 숫자만 입력해야 합니다.

### API 예약/반복 결제 주요 파라미터

- paymentId: string

  고객사에서 채번하는 주문 고유 번호로 매번 고유하게 채번되어야 하며, URL path에 포함돼야 합니다.

- payment: object

  **빌링키 결제 요청 입력정보**

  - billingKey: string

    **빌링키 결제에 사용할 빌링키**

  - orderName: string

    **주문명**

  - amount: object

    **결제 금액**

    - total: number

      **총 결제 금액**

      결제 금액으로 결제를 원하는 통화(currency)별 scale factor(소수점 몇번째 자리까지 유효한지)를 고려한 number 형식만 허용됩니다.

    - taxFree?: number

      **면세액**

      결제 금액으로 결제를 원하는 통화(currency)별 scale factor(소수점 몇번째 자리까지 유효한지)를 고려한 number 형식만 허용됩니다.

      나이스페이먼츠와 지정금액 혹은 복합과세 방식으로 계약한 경우 면세금액을 반드시 입력해야 합니다.
      카드 빌링키의 경우 면세금액 미입력 시 면세금액은 0원으로 자동 처리되며, 결제 요청 금액은 모두 과세 처리 되오니 이 점 유의하시기 바랍니다.
      간편결제 빌링키의 경우 면세금액 미입력 시 오류가 발생합니다.

    - vatAmount?: number

      **부가세**

      결제 금액으로 결제를 원하는 통화(currency)별 scale factor(소수점 몇번째 자리까지 유효한지)를 고려한 number 형식만 허용됩니다.

      나이스페이먼츠와 지정금액 혹은 복합과세 방식으로 계약한 경우 간편결제 빌링키 이용 시 부가세를 반드시 입력해야 합니다.

  - currency: string

    **결제 통화**

    결제통화로 원화 결제 시 `KRW`로 입력해야 합니다. (신)나이스페이먼츠의 경우 빌링키로 결제시 `KRW`만 지원합니다.

  - customer: object

    **고객 정보**

    - id: string

      **고객 아이디**

      고객사가 지정한 고객의 고유 식별자입니다.

    - name?: string

      **고객 이름**

      고객의 이름을 입력합니다.

      네이버페이 빌링키 결제 시 환금성 업종 가맹점은 필수 입력입니다.

    - email?: string

      **이메일**

    - phoneNumber?: string

      **전화번호**

    - birthYear?: string

      **출생 연도**

      네이버페이 빌링키 결제 시 환금성 업종 가맹점은 필수 입력입니다.

    - birthMonth?: string

      **출생 월**

      네이버페이 빌링키 결제 시 환금성 업종 가맹점은 필수 입력입니다.

    - birthDay?: string

      **출생 일**

      네이버페이 빌링키 결제 시 환금성 업종 가맹점은 필수 입력입니다.

  - cashReceipt?: object

    **현금영수증 입력 정보**

    네이버페이 빌링키 결제 시 현금영수증 대상 가맹점의 경우 필수 입력입니다.

    - type: string

      **현금영수증 발급 유형**

      - 소득공제용: `PERSONAL`
      - 지출증빙용: `CORPORATE`
      - 미발행: `NO_RECEIPT`

    - customerIdentityNumber?: string

      **사용자 식별 번호**

      - 소득공제용의 경우 휴대폰번호(10자리 혹은 11자리)를 입력합니다.
      - 지출증빙용의 경우 사업자번호(10자리)를 입력합니다.

- timeToPay: string

  결제를 시도할 시각으로 ISO 8601 형식으로 입력해야 합니다.

## 연동 유의사항

### 나이스페이먼츠와 사전 계약이 필요한 경우

아래 기능을 사용하시려면 나이스페이먼츠에 사전 신청 후 계약이 완료되어야 합니다.
그렇지 않은 상태에서 해당 기능 이용시 PG창 호출에 실패하거나, 승인에 실패하거나,
승인에 성공하더라도 의도한 바와는 다른 응답을 얻게 될 수 있으니 이 점 유의하시길 바랍니다.

- 모든 결제 수단(간편결제 포함)

- 면세 / 복합과세 사용

- 부가세 지정 금액 방식 사용(영세율 포함)

- 부분 취소

- 할부 사용

- 상점 부담 무이자 할부 사용

- 카드사 포인트 사용

- 에스크로 사용

- 해외 결제 사용

- 일부 bypass 파라미터
  - UserCI
  - MallUserID
  - DirectCouponYN
  - PaycoClientId, PaycoAccessToken
  - SamPayMallType

### 일반결제 공통 유의사항

- 결제창 호출 실패 사유 알 수 없음
  - 상점 아이디 설정 이슈, 파라미터 설정 오류 등으로 결제창 호출이 불가능한 경우 PG사로부터 정확한
    사유를 전달 받고 있지 않아 “알 수 없는 이유로 결제가 중단되었습니다. 나이스페이로
    문의(1661-0808)하세요.”라는 에러를 리턴합니다. 이 메시지를 받으신 경우 결제창 호출 시 사용한
    파라미터 전문과 함께 포트원으로 문의해 주시길 바랍니다.

### 카드 일반결제 유의사항

|기능                                 |사용 가능 여부                                            |
|-------------------------------------|----------------------------------------------------------|
|상점 부담 무이자 할부                |가능                                                      |
|다이렉트 호출                        |`단독 사용 불가능(고정 할부 개월수가 함께 전달 되어야 함)`|
|다이렉트 호출 + 고정 할부 개월수     |가능                                                      |
|다이렉트 호출 + 리스트 할부 개월수   |`불가능`                                                  |
|비 다이렉트 호출 + 고정 할부 개월수  |`PC만 가능`                                               |
|비 다이렉트 호출 + 리스트 할부 개월수|`PC만 가능`                                               |

- 토스뱅크 카드의 경우 카드사 다이렉트 호출 불가능합니다.
  - 나이스페이먼츠의 경우 토스뱅크 카드 다이렉트 호출이 지원되지 않습니다.

- 모바일 환경에서는 다이렉트 호출시에만 할부 옵션 설정이 가능합니다. -나이스페이먼츠의 경우 일반
  카드 결제 시(간편결제 제외) 할부 옵션(고정 할부 개월수)사용이 가능하나 **모바일 환경**에서는
  **카드사 다이렉트 호출할 때만 할부 옵션 사용이 가능합니다.** 만약 모바일 환경에서 다이렉트 호출
  코드 없이 할부 옵션을 전달하는 경우 무시됩니다.

### 계좌이체 일반결제 유의사항

- 계좌이체 다이렉트 호출 시 은행 코드 지정이 불가능합니다.
  - 나이스페이먼츠의 경우 계좌이체 다이렉트 호출을 하더라도 뱅크페이가 호출되오니 이 점 유의하시기 바랍니다.
  - 다이렉트 호출을 원하시는 경우 은행코드 대신 bypass 파라미터인 `DirectShowOpt`를 설정하여 사용하시길 바랍니다.

- 계좌이체 에스크로 결제시에는 다이렉트 호출이 불가능합니다.
  - 나이스페이먼츠 정책상 에스크로를 사용한 계좌이체 결제시에는 다이렉트 호출이 불가능합니다. 아래와
    같이 계좌이체 + 에스크로 + 다이렉트 호출을 위한 파라미터를 설정할 경우 "나이스페이 V2 계좌이체
    에스크로 결제시 다이렉트 호출은 불가능합니다."라는 에러 메시지가 리턴되며, 결제창이 호출되지
    않으니 유의하시기 바랍니다.

- 계좌이체 에스크로 결제시 결제창에 올바른 이메일을 입력해야 합니다.
  - 존재하지 않는 이메일을 입력할 경우 **이메일 주소 오류**라는 에러 메시지와 함께 승인 실패됩니다.
    또한 실제로 존재하는 이메일 도메인이더라도 나이스페이먼츠 정책상 유효하지 않다고 취급하는 이메일
    주소((예) <ex@portone.finance>)를 입력한 경우 정상 승인되지만 **이후 에스크로 API를 이용하여 배송
    정보 등록 시 에스크로 구매 확정 이메일이 전송되지 않습니다.**

- 사파리 브라우저의 경우 미지원 대상으로 결제가 원활하지 않습니다.

### 상품권 일반결제 유의사항

- 승인 완료시 나이스페이먼츠로부터 승인번호(`approvalNumber`)가 전달되지 않으니 이 점 유의하시기 바랍니다.
  - 나이스페이먼츠는 상품권 결제시 별도의 승인 번호를 전달하지 않습니다. 따라서 결제 내역 조회시 승인 번호가 null로 리턴됩니다.

### 카카오페이 일반결제 유의사항

|기능                                          |사용 가능 여부                                                        |
|----------------------------------------------|----------------------------------------------------------------------|
|상점 부담 무이자 할부                         |`불가능`                                                              |
|카드사 지정 다이렉트 호출                     |BC, 국민, 삼성, 신한, 현대, 롯데, 씨티, NH농협 그리고 하나 카드만 가능|
|카드사 지정 다이렉트 호출 + 고정 할부 개월수  |BC, 국민, 삼성, 신한, 현대, 롯데, 씨티, NH농협 그리고 하나 카드만 가능|
|카드사 지정 다이렉트 호출 + 리스트 할부 개월수|`불가능`                                                              |
|비 다이렉트 호출 + 고정 할부 개월수           |`불가능`                                                              |
|비 다이렉트 호출 + 리스트 할부 개월수         |`불가능`                                                              |

### 네이버페이 일반결제 유의사항

|기능                                          |사용 가능 여부                                                        |
|----------------------------------------------|----------------------------------------------------------------------|
|상점 부담 무이자 할부                         |`불가능`                                                              |
|카드사 지정 다이렉트 호출                     |BC, 국민, 삼성, 신한, 현대, 롯데, 씨티, NH농협 그리고 하나 카드만 가능|
|카드사 지정 다이렉트 호출 + 고정 할부 개월수  |BC, 국민, 삼성, 신한, 현대, 롯데, 씨티, NH농협 그리고 하나 카드만 가능|
|카드사 지정 다이렉트 호출 + 리스트 할부 개월수|가능(단, `일시불이 항상 포함` 됨)                                     |
|비 다이렉트 호출 + 고정 할부 개월수           |`불가능`                                                              |
|비 다이렉트 호출 + 리스트 할부 개월수         |가능(단, `일시불이 항상 포함` 됨)                                     |

- 네이버페이 머니와 포인트 복합 결제 시, 포인트가 먼저 사용 됩니다.
  - 네이버페이 포인트 결제 시 네이버페이 머니, 포인트 또는 복합(머니와 포인트 함께 사용) 방식으로
    결제가 가능하며, 만약 복합 방식으로 결제할 경우 포인트 금액이 먼저 차감됩니다.

- 네이버페이 포인트 결제 시 현금영수증 정보를 필수 입력해야합니다.
  - 네이버페이 포인트 결제 시 현금영수증 발급이 가능하며 **현금영수증
    정보(`easyPay.cashReceiptType`, `easyPay.customerIdentifier`)를 필수로 입력**해야 합니다. 만약
    입력하지 않을 경우 "나이스페이 V2 네이버페이 포인트 결제시 현금영수증 발급 유형은 필수
    입력입니다."라는 에러 메시지가 리턴되며, 결제창이 호출되지 않으니 유의하시기 바랍니다. 단,
    **네이버페이 머니로 결제할 경우에만 현금영수증이 발급**됩니다. 결제 금액 모두 네이버페이
    포인트로 결제하는 경우에는 결제창 호출 시 현금영수증 정보를 전달하더라도 발급되지 않습니다.

### 페이코 일반결제 유의사항

|기능                                          |사용 가능 여부|
|----------------------------------------------|--------------|
|상점 부담 무이자 할부                         |가능          |
|카드사 지정 다이렉트 호출                     |가능          |
|카드사 지정 다이렉트 호출 + 고정 할부 개월수  |가능          |
|카드사 지정 다이렉트 호출 + 리스트 할부 개월수|가능          |
|비 다이렉트 호출 + 고정 할부 개월수           |`불가능`      |
|비 다이렉트 호출 + 리스트 할부 개월수         |가능          |

### 삼성페이/11Pay(구.SKPay)/SSGPAY 일반결제 유의사항

|기능                                          |사용 가능 여부|
|----------------------------------------------|--------------|
|상점 부담 무이자 할부                         |가능          |
|카드사 지정 다이렉트 호출                     |`불가능`      |
|카드사 지정 다이렉트 호출 + 고정 할부 개월수  |`불가능`      |
|카드사 지정 다이렉트 호출 + 리스트 할부 개월수|`불가능`      |
|비 다이렉트 호출 + 고정 할부 개월수           |`불가능`      |
|비 다이렉트 호출 + 리스트 할부 개월수         |`불가능`      |

### 애플페이/LPAY 일반결제 유의사항

|기능                                          |사용 가능 여부|
|----------------------------------------------|--------------|
|상점 부담 무이자 할부                         |`불가능`      |
|카드사 지정 다이렉트 호출                     |`불가능`      |
|카드사 지정 다이렉트 호출 + 고정 할부 개월수  |`불가능`      |
|카드사 지정 다이렉트 호출 + 리스트 할부 개월수|`불가능`      |
|비 다이렉트 호출 + 고정 할부 개월수           |`불가능`      |
|비 다이렉트 호출 + 리스트 할부 개월수         |`불가능`      |

### SSG페이 계좌 결제 유의사항

- SSG페이 계좌 결제는 현금성 결제로 현금영수증 발급이 가능하므로 **현금영수증
  정보(`easyPay.cashReceiptType`, `easyPay.customerIdentifier`)는 필수 입력**입니다. 만약 입력하지
  않을 경우 "나이스페이 V2 SSGPAY 은행 계좌 결제시 현금영수증 발급 유형은 필수 입력입니다."라는 에러
  메시지가 뜨면서 결제창이 호출되지 않으니 유의하시기 바랍니다.

- SSG페이 계좌 결제 시 주문 번호(`paymentId`)에 특수문자 사용이 불가능합니다.

- SSGPAY 계좌 결제 시 현금영수증 발급 정보를 확인할 수 없습니다.
  - SSGPAY 은행 계좌 결제 시 현금영수증 발급 정보를 입력하여 정상적으로 발급되더라도 승인
    완료(status: paid)시 나이스페이먼츠에서 현금영수증 발급 정보를 전달하지 않아 포트원 API로
    결제/현금영수증 발급 내역 조회 또는 포트원 콘솔에서 현금영수증 내역을 확인할 수 없습니다. 단,
    나이스페이먼츠 어드민에서는 확인이 가능하오니 확인이 필요한 경우 나이스페이먼츠 어드민에서
    확인하시길 바랍니다.

<details>

<summary>파라미터 예시</summary>

```ts
PortOne.requestPayment({
  // ...중략
  payMethod: "EASY_PAY",
  easyPay: {
    easyPayProvider: "SSGPAY",
    availablePayMethods: "TRANSGER",
    cashReceiptType: "PERSONAL",
    customerIdentifier: "01000000000",
  },
});
```

</details>

### 일반결제 현금영수증 유의사항

- SDK 파라미터로 현금영수증 식별 번호를 전달하는 경우 휴대폰 번호만 사용 가능합니다.
  - 계좌이체 다이렉트 호출, 네이버페이 포인트 결제, SSGPAY 계좌 결제 시 현금영수증 정보는 필수
    입력입니다. 단, 휴대폰 번호가 아닌 주민등록번호를 전달한 경우 현금영수증이 정상적으로 발급되지
    않으니 유의하시기 바랍니다.

- 가상계좌 발급 혹은 일반적인 계좌이체(다이렉트 호출하지 않은 경우) 결제 시 현금영수증 파라미터를
  입력에 유의하시기 바랍니다.
  - 결제창을 통한 가상계좌 발급 또는 일반적인 계좌이체(비 다이렉트 호출) 결제 시에는 현금영수증
    정보를 파라미터로 전달할 수 없기(전달하더라도 결제창에 자동 입력되지 않음)때문에 구매자가
    결제창에 직접 현금영수증 정보를 입력해야 합니다. 만약 비 다이렉트 호출 시 현금영수증 정보를
    파라미터로 넘기는 경우 **결제 창 호출에 실패하였습니다. 나이스페이 V2 계좌이체 결제시 현금영수증
    정보는 다이렉트 호출시에만 입력 가능합니다.** 라는 에러메세지와 함께 결제창이 호출되지 않습니다.

### API 지원 기능

나이스페이먼츠는 API를 통해 아래 기능들을 지원합니다.

- 카드 빌링키 발급
- 카드 및 간편결제 빌링키 결제
- 수기(키인) 결제
- 예약 결제
- 결제 취소(가상계좌 환불 포함)
- 에스크로 배송 정보 등록, 조회(수정 불가능)
- 가상계좌 발급, 말소
- 포트원 외부 결제 건 현금영수증 발급, 조회, 취소

### 가상계좌 발급 API 유의사항

- 고정식 가상계좌 지원합니다.
  - 나이스페이먼츠의 경우 API를 통한 고정식 가상계좌 사용을 지원합니다. 고정식 가상계좌를 사용하기
    위해서는 `virtualAccount.option.type`를 `FIXED`로 전달해야 합니다. 단, 고정식 가상계좌 및
    과오납체크를 사용하도록 나이스페이먼츠와 사전 협의가 필요합니다.

### 에스크로 API 유의사항

- 배송 정보 등록시 유의할 파라미터
  - 배송자 이름인 `sender.name` 파라미터가 필수 입니다.

  - 배송지 주소인 `receiver.address` 파라미터가 필수입니다.

  - 이메일 전송 여부인 `sendEmail` 파라미터가 필수입니다.
    - 나이스페이먼츠의 경우 다른 PG에서는 지원하지 않는 `sendEmail` 파라미터를 지원합니다.
    - 에스크로 구매 확정시 결제 창에 입력했던 이메일로 해당 사실을 전송할지 여부. (기본값: true | boolean type)

- 배송 정보 수정 불가합니다.
  - 나이스페이먼츠는 API로 에스크로 배송 정보 등록은 가능하지만 **수정은 불가능**합니다.

### 현금영수증 API 유의사항

- 결제창에서 발급 받지 못한 현금영수증은 API로 발급 불가능합니다.
  - 나이스페이먼츠의 경우 현금성 결제(가상계좌, 계좌이체, 네이버페이 포인트 결제 등)시 승인 단계에서
    현금영수증을 발급 요청할 수 있습니다. 이때 결제 승인 단계에서 현금영수증을 발급 요청하지 못한
    경우, 현금영수증 발급 API(`POST /cash-receipts`)를 사용한다고 하더라도 발급이 되지 않으니 참고
    부탁드립니다.

- API로 현금영수증 발급 시, 현금영수증 카드 사용이 불가능합니다.
  - API로 현금영수증 발급(`POST /cash-receipts`)시 발급 받을 현금영수증 정보(현금영수증 발급 유형,
    현금영수증 발행 식별 정보)를 전달해야 합니다. 단, 나이스페이먼츠의 경우 **발행 식별 정보 중
    현금영수증 카드 번호는 사용이 불가능**하오니 참고 부탁드립니다.
